
#ifndef _1_CRYS_ATP_TST_RND_Acceptance_h_H
#define _1_CRYS_ATP_TST_RND_Acceptance_h_H

#include "CRYS_ATP_TST_Defines.h"
#if TST_USE_RND_DATA/*In case no test vectors are selected - code disabled*/
/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Sun Mar 06 20:42:10 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_RND_Acceptance.h#1:incl:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */


/******** Defines ***********/
/******** Enums ***********/
/******** Typedefs  ***********/
/******** Structs  **********/
typedef struct TST_RND_TestDataStruct{	
	DxUint8_t 					TST_RND_Output1[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
	DxUint8_t 					TST_RND_Output2[TST_MAX_DATA_VEC_SIZE_IN_BYTS];
} TST_RND_TestDataStruct;

typedef struct TST_PRNGInstantiation_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t					TST_FirstEntropy[8];
	DxUint8_t					TST_Entropy[16];
	DxUint8_t					TST_AdditionalInput1[16];
	DxUint8_t					TST_AdditionalInput2[16];
	DxUint8_t					TST_ExpResult1[8];
	DxUint8_t					TST_ExpResult2[8];
} TST_PRNGInstantiation_TestDataStruct;

typedef struct TST_PRNGReSeeding_TestDataStruct{	
	char					    TST_Name[TST_NAME_STRING_LEN];
	DxUint8_t					TST_FirstEntropy[8];
	DxUint8_t					TST_Entropy[16];
	DxUint8_t					TST_ReSeedingEntropy1[16];
	DxUint8_t					TST_ReSeedingEntropy2[16];
	DxUint8_t					TST_ReSeedingAddInput[16];
	DxUint8_t					TST_ExpResult1[8];
	DxUint8_t					TST_ExpResult2[8];
} TST_PRNGReSeeding_TestDataStruct;
/******** Public Variables ********/
/******** Public Functions ********/
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RND_Acceptance_No_Reset 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for Random API's							
 * 									
 * Algorithm:		
 * 1. Call the CRYS_RND_GenerateVector function to generate a random value
 * 2. Call the CRYS_RND_GenerateVector to generate a random second random value
 * 3. Compare the random numbers and verify the are different												
 *
 **************************/
CRYSError_t CRYS_ATP_TST_RND_Acceptance_No_Reset ( void );
/***************************
 * Function Name:                                                           
 * 	CRYS_ATP_TST_RND_Acceptance_No_Reset 		
 * 
 * Inputs:
 * 	None
 *
 * Outputs:
 * 	CRYSError_t - Function error return		    					  		
 *
 * Description:																	
 * 	This function Is a Acceptance test for Random API's	
 *  Generating different randoms in verious sizes	
 *  With Seed reset before any generation					
 * 									
 * Algorithm:		
 * 1. Call the CRYS_RND_GenerateVector function to generate a random value
 * 2. Call the CRYS_RND_GenerateVector to generate a random second random value
 * 3. Compare the random numbers and verify the are different												
 *
 **************************/								
CRYSError_t CRYS_ATP_TST_RND_Acceptance_Reset ( void );

#ifdef RND_KAT_TEST_MODE_FOR_VER_21
/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_PRNG_Acceptance_Instantiation        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
The test are based on the tests specifications,
described in the Random Number Generator System Specification Revision 2.1.
To run these tests the project should be compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.

Notes: There are two global variables that contain entropy values that are used in PRNG functions,
only if these functions are compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.
The responsibility of the ATP test is to define these global variables and
to initialize them with requested by test specification values.

The instantiation function initializes the RNG.
This function should be called before any other PRNG operation.
                 
                                
 * Algorithm:       
1.	Initialize global first entropy (GlobalFirstEntropy) with test vector value  TST_FirstEntropy
2.	Initialize global entropy (GlobalEntropy) with test vector value TST_Entropy
3.	Call CRYS_RND_AddAdditionalInput with additional input test vector TST_AdditionalInput1 with size 16 bytes
4.	Call CRYS_RND_Instantiation function
5.	Call CRYS_RND_GenerateVector with size 112
6.	Compare output result with expected result TST_ExpResult1
7.	Call CRYS_RND_AddAdditionalInput with additional input test vector TST_AdditionalInput2 with size 16 bytes
9.	Call CRYS_RND_GenerateVector with size 8 bytes 
9.	Compare output result with expected result TST_ExpResult2
 ******************************************************************************/
CRYSError_t CRYS_ATP_TST_PRNG_Acceptance_Instantiation ( void );

/*****************************************************************************
 * Function Name:                                                           
 *  CRYS_ATP_TST_PRNG_Acceptance_ReSeeding        
 * 
 * Inputs:
 *  None
 *
 * Outputs:
 *  CRYSError_t - Function error return                                     
 *
 * Description:                                                                 
The test are based on the tests specifications,
described in the Random Number Generator System Specification Revision 2.1.
To run these tests the project should be compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.

Notes: There are two global variables that contain entropy values that are used in PRNG functions,
only if these functions are compiled with RND_KAT_TEST_MODE_FOR_VER_21 preprocessor definition.
The responsibility of the ATP test is to define these global variables and
to initialize them with requested by test specification values.

Reseeding provides mixing of additional entropy into the working state.


 *                                  
 * Algorithm:       
1.	Initialize global first entropy (GlobalFirstEntropy) with test vector value  TST_FirstEntropy
2.	Initialize global entropy (GlobalEntropy) with test vector value TST_Entropy
3.	Call function CRYS_RND_Instantiation
4.	Initialize global entropy (GlobalEntropy) with test vector value TST_ReSeedingEntropy1
5.	Call CRYS_RND_Reseeding function
6.	Call CRYS_RND_GenerateVector with size 8
7.	Compare output result with expected output TST_ExpResult1
8.	Initialize global entropy with test vector TST_ReSeedingEntropy2
9.	Call CRYS_RND_AddAdditionalInput with additional input test vector  TST_ReSeedingAddInput 
10.	Call CRYS_RND_Reseeding function
11.	Call CRYS_RND_GenerateVector with size 8 bytes 
12.	Compare output result with expected result TST_ExpResult2  
******************************************************************************/
CRYSError_t CRYS_ATP_TST_PRNG_Acceptance_ReSeeding ( void );

#endif


#ifdef __cplusplus
}
#endif

#endif

#endif


